﻿/*
	Name:			XenoN Core 2D Component Header
	Version:		1.5
	Update:			2011-02-24
	Copyright:		Copyright © 2007-2011 XenoN Core by PsichiX. All rights reserved.
	Author:			PsichiX
	Website:		http://www.xenon.psichix.com
	Description:	XenoN Core Framework 2D Component Header
*/

/*
	== EN ==
	This file is part of Xenon Core Framework.
	You may distribute it further, but you can not modify it.
	Please do not use in modified form.
	The principles of XenoN Core License available in the file LICENSE_CORE_EN.TXT or visit: http://www.xenon.psichix.com.

	== PL ==
	Ten plik jest czescia XenoN Core Framework.
	Mozesz go rozpowszechniac dalej, jednak nie mozesz go modyfikowac.
	Nalezy uzytkowac w nie zmodyfikowanej formie.
	Nalezy przestrzegac zasad Licencji XenoN Core dostepnej w pliku LICENSE_CORE_PL.TXT oraz na stronie: http://www.xenon.psichix.com.
*/

#ifndef XE_COMPONENT_2D_H
#define XE_COMPONENT_2D_H

#include "../System/XenonCoreFramework.h"

namespace XeCore
{
//! Przestrzen nazw komponentow
namespace Com
{

class C_VIEW;
class C_SHAPES;
class C_SKELETON;

#ifdef XE_COMPILE_PHOTON
#ifdef XE_COMPILE_CORE_MATH

//! Klasa widoku.
class C_VIEW
{
public:
					//! Okresla czy view jest aktywny
	bool			Active;
					//! Pozycja w widoku.
	XE_VECTOR		ViewPortPos;
					//! Rozmiar w widoku.
	XE_VECTOR		ViewPortSize;
					//! Pozycja na scenie.
	XE_VECTOR		ScenePortPos;
					//! Rozmiar na scenie.
	XE_VECTOR		ScenePortSize;
					//! Obrót viewa.
	float			Angle;
					//! Aktor, za którym ma podążać.
	XE_ACTOR*		Follow;
					//! Ustala czy przy aktywacji ma być czyszczone tło
	bool			ClearBG;
					//! Konstruktor obiektu.
					C_VIEW();
					//! Aktywacja viewa.
	void			Activate();
					//! Dezaktywacja viewa.
	static void		Unactivate();
};
//! Definicja elementu viewa.
typedef XE_ELEMENT_POINTER<C_VIEW> C_ELM_VIEW;

#ifdef XE_CANIMP

C_VIEW::C_VIEW()
{
	Active = false;
	Angle = 0;
	Follow = NULL;
	ClearBG = true;
}

void C_VIEW::Activate()
{
	if(!Active)return;
	if(Follow!=NULL)
	{
		ScenePortPos.X=Follow->Position.X-ScenePortSize.X/2;
		ScenePortPos.Y=Follow->Position.Y-ScenePortSize.Y/2;
	}
	int* x=(int*)Photon::XeRenderTargetGet(*(XE_ELM_RENDERTARGET*)XeGetState(XE_RENDERTARGET),XE_RENDERTARGET_X);
	int* y=(int*)Photon::XeRenderTargetGet(*(XE_ELM_RENDERTARGET*)XeGetState(XE_RENDERTARGET),XE_RENDERTARGET_Y);
	int* w=(int*)Photon::XeRenderTargetGet(*(XE_ELM_RENDERTARGET*)XeGetState(XE_RENDERTARGET),XE_RENDERTARGET_WIDTH);
	int* h=(int*)Photon::XeRenderTargetGet(*(XE_ELM_RENDERTARGET*)XeGetState(XE_RENDERTARGET),XE_RENDERTARGET_HEIGHT);
	int _x=*x;
	int _y=*y;
	int _w=*w;
	int _h=*h;
	*x=(int)ViewPortPos.X;
	*y=(int)ViewPortPos.Y;
	*w=(int)ViewPortSize.X;
	*h=(int)ViewPortSize.Y;
	Photon::XeRenderTargetActivate(*(XE_ELM_RENDERTARGET*)XeGetState(XE_RENDERTARGET));
	XeCameraOrtho(ScenePortPos.X,ScenePortPos.Y,ScenePortSize.X,ScenePortSize.Y,Angle);
	XeSetState(XE_RENDER_SCISSOR_MODE,XE_TRUE);
	XeSetState(XE_RENDER_SCISSOR,(int)ViewPortPos.X,(int)ViewPortPos.Y,(int)ViewPortSize.X,(int)ViewPortSize.Y);
	*x=_x;
	*y=_y;
	*w=_w;
	*h=_h;
	if(ClearBG)Photon::XeRenderScene(XE_FLAG_COLORBUFF);
}

void C_VIEW::Unactivate()
{
	Photon::XeRenderTargetActivate(*(XE_ELM_RENDERTARGET*)XeGetState(XE_RENDERTARGET));
	int* x=(int*)Photon::XeRenderTargetGet(*(XE_ELM_RENDERTARGET*)XeGetState(XE_RENDERTARGET),XE_RENDERTARGET_X);
	int* y=(int*)Photon::XeRenderTargetGet(*(XE_ELM_RENDERTARGET*)XeGetState(XE_RENDERTARGET),XE_RENDERTARGET_Y);
	int* w=(int*)Photon::XeRenderTargetGet(*(XE_ELM_RENDERTARGET*)XeGetState(XE_RENDERTARGET),XE_RENDERTARGET_WIDTH);
	int* h=(int*)Photon::XeRenderTargetGet(*(XE_ELM_RENDERTARGET*)XeGetState(XE_RENDERTARGET),XE_RENDERTARGET_HEIGHT);
	XeCameraOrtho((double)*x,(double)*y,(double)*w,(double)*h,0);
	XeSetState(XE_RENDER_SCISSOR_MODE,XE_FALSE);
	XeSetState(XE_RENDER_SCISSOR,*x,*y,*w,*h);
}

#endif /* XE_CANIMP */

//! Klasa ksztaltow graficznych.
class C_SHAPES
{
public:
			//! Klasa okregu.
	class	CIRCLE
	{
	public:
						//! Promien.
		float			Range;
						//! Jakosc.
		int				Quality;
						//! Ustala czy ma rysowac wypelniona figure czy tylko obramowanie.
		bool			Filled;
						//! Tekstura.
		XE_ELM_TEXTURE	Texture;
						//! Tablica kolorow.
		XE_VECTOR		Color[2];
						/*! Konstruktor domyslny. */
						CIRCLE();
						/*! Rysowanie okregu.
						\param pos Wektor pozycji okregu.
						\param angle Kat obrotu.
						\param buffered Ustala czy dane do rysowania maja byc buforowane.
						*/
		void			Draw(XE_VECTOR pos=XE_VECTOR(),float angle=0,bool buffered=true);
	};
			//! Klasa trojkata.
	class	TRIANGLE
	{
	public:
						//! Ustala czy ma rysowac wypelniona figure czy tylko obramowanie.
		bool			Filled;
						//! Tekstura.
		XE_ELM_TEXTURE	Texture;
						//! Pozycje wierzcholkow.
		XE_VECTOR		Vertex[3];
						//! Koordynaty tekstury wierzcholkow.
		XE_VECTOR		Coord[3];
						//! Tablica kolorow.
		XE_VECTOR		Color[3];
						/*! Konstruktor domyslny. */
						TRIANGLE();
						/*! Rysowanie trojkata.
						\param pos Wektor pozycji trojkata.
						*/
		void			Draw(XE_VECTOR pos=XE_VECTOR());
	};
			//! Klasa czworokata.
	class	RECTANGLE
	{
	public:
						//! Ustala czy ma rysowac wypelniona figure czy tylko obramowanie.
		bool			Filled;
						//! Tekstura.
		XE_ELM_TEXTURE	Texture;
						//! Punkt poczatkowa figury.
		XE_VECTOR		Begin;
						//! Punkt koncowy figury.
		XE_VECTOR		End;
						//! Tablica kolorow.
		XE_VECTOR		Color[4];
						/*! Konstruktor domyslny. */
						RECTANGLE();
						/*! Rysowanie czworokata.
						\param pos Wektor pozycji czworokata.
						\param buffered Ustala czy dane do rysowania maja byc buforowane.
						*/
		void			Draw(XE_VECTOR pos=XE_VECTOR(),bool buffered=true);
	};
};

#ifdef XE_CANIMP

C_SHAPES::CIRCLE::CIRCLE()
{
	Range = 0;
	Quality = 0;
	Filled = false;
}

void C_SHAPES::CIRCLE::Draw(XE_VECTOR pos,float angle,bool buffered)
{
	if(!Texture.IsEmpty())
		Photon::XeTextureActivate(Texture);
	else
		Photon::XeTextureUnactivate();
	XE_ARRAY<XE_VECTOR> vertices;
	XE_ARRAY<XE_VECTOR> coords;
	XE_ARRAY<XE_VECTOR> colors;
	if(buffered)
	{
		if(Filled)
		{
			vertices.Reserve((unsigned int)Quality+2);
			coords.Reserve((unsigned int)Quality+2);
			colors.Reserve((unsigned int)Quality+2);
			vertices[0]=pos;
			coords[0]=XE_VECTOR(0.5,0.5);
			colors[0]=Color[0];
		}
		else
		{
			vertices.Reserve((unsigned int)Quality);
			coords.Reserve((unsigned int)Quality);
			colors.Reserve((unsigned int)Quality);
		}
	}
	else
	{
		if(Filled)
		{
			Photon::XePrimitiveBegin(XE_TRIANGLEFAN);
			Photon::XePutTexvertex(XE_VECTOR(0.5,0.5));
			XeSetState(XE_COLOR,Color[0]);
			Photon::XePutVertex(pos);
		}
		else
			Photon::XePrimitiveBegin(XE_LINELOOP);
	}
	XE_VECTOR v,c;
	for(int i=0;i<=Quality;i++)
	{
		if(!Filled&&i==Quality)break;
		v=pos+XeLengthdirLen(360.0f/(float)Quality*(float)i+angle,Range);
		c=XE_VECTOR(0.5,0.5)+XeLengthdirLen(360.0f/(float)Quality*(float)i,0.5);
		if(buffered)
		{
			if(Filled)
			{
				vertices[i+1]=v;
				coords[i+1]=c;
				colors[i+1]=Color[1];
			}
			else
			{
				vertices[i]=v;
				coords[i]=c;
				colors[i]=Color[1];
			}
		}
		else
		{
			Photon::XePutTexvertex(c);
			XeSetState(XE_COLOR,Color[1]);
			Photon::XePutVertex(v);
		}
	}
	if(buffered)
	{
		if(Filled)
			Photon::XeDrawData(XE_TRIANGLEFAN,0,Quality+2,vertices.Get(),colors.Get(),coords.Get(),0,0,0,XE_DOUBLE);
		else
			Photon::XeDrawData(XE_LINELOOP,0,Quality,vertices.Get(),colors.Get(),coords.Get(),0,0,0,XE_DOUBLE);
		vertices.Free();
		coords.Free();
		colors.Free();
	}
	else
		Photon::XePrimitiveEnd();
	XeSetState(XE_COLOR,XE_VECTOR(1,1,1));
}

C_SHAPES::TRIANGLE::TRIANGLE()
{
	Filled = false;
}

void C_SHAPES::TRIANGLE::Draw(XE_VECTOR pos)
{
	if(!Texture.IsEmpty())
		Photon::XeTextureActivate(Texture);
	else
		Photon::XeTextureUnactivate();
	Photon::XeMatrixPush();
	Photon::XeMatrixTranslate(pos.X,pos.Y,pos.Z);
	if(Filled)
		Photon::XeDrawData(XE_TRIANGLES,0,3,Vertex,Color,Coord,0,0,0,XE_DOUBLE);
	else
		Photon::XeDrawData(XE_LINELOOP,0,3,Vertex,Color,Coord,0,0,0,XE_DOUBLE);
	Photon::XeMatrixPop();
	XeSetState(XE_COLOR,XE_VECTOR(1,1,1));
}

C_SHAPES::RECTANGLE::RECTANGLE()
{
	Filled = false;
}

void C_SHAPES::RECTANGLE::Draw(XE_VECTOR pos,bool buffered)
{
	if(!Texture.IsEmpty())
		Photon::XeTextureActivate(Texture);
	else
		Photon::XeTextureUnactivate();
	XE_ARRAY<XE_VECTOR> vertices;
	XE_ARRAY<XE_VECTOR> coords;
	if(buffered)
	{
		vertices.Reserve(4);
		coords.Reserve(4);
		vertices[0].X=Begin.X+pos.X;
		vertices[0].Y=Begin.Y+pos.Y;
		coords[0]=XE_VECTOR(0,0);
		vertices[1].X=End.X+pos.X;
		vertices[1].Y=Begin.Y+pos.Y;
		coords[1]=XE_VECTOR(1,0);
		vertices[2].X=End.X+pos.X;
		vertices[2].Y=End.Y+pos.Y;
		coords[2]=XE_VECTOR(1,1);
		vertices[3].X=Begin.X+pos.X;
		vertices[3].Y=End.Y+pos.Y;
		coords[3]=XE_VECTOR(0,1);
		if(Filled)
			Photon::XeDrawData(XE_QUADS,0,4,vertices.Get(),Color,coords.Get(),0,0,0,XE_DOUBLE);
		else
			Photon::XeDrawData(XE_LINELOOP,0,4,vertices.Get(),Color,coords.Get(),0,0,0,XE_DOUBLE);
		vertices.Free();
		coords.Free();
	}
	else
	{
		if(Filled)
			Photon::XePrimitiveBegin(XE_QUADS);
		else
			Photon::XePrimitiveBegin(XE_LINELOOP);
		Photon::XePutTexvertex(XE_VECTOR(0,0));
		XeSetState(XE_COLOR,Color[0]);
		Photon::XePutVertex(XE_VECTOR(Begin.X+pos.X,Begin.Y+pos.Y));
		Photon::XePutTexvertex(XE_VECTOR(1,0));
		XeSetState(XE_COLOR,Color[1]);
		Photon::XePutVertex(XE_VECTOR(End.X+pos.X,Begin.Y+pos.Y));
		Photon::XePutTexvertex(XE_VECTOR(1,1));
		XeSetState(XE_COLOR,Color[2]);
		Photon::XePutVertex(XE_VECTOR(End.X+pos.X,End.Y+pos.Y));
		Photon::XePutTexvertex(XE_VECTOR(0,1));
		XeSetState(XE_COLOR,Color[3]);
		Photon::XePutVertex(XE_VECTOR(Begin.X+pos.X,End.Y+pos.Y));
		Photon::XePrimitiveEnd();
	}
	XeSetState(XE_COLOR,XE_VECTOR(1,1,1));
}

#endif /* XE_CANIMP */

//! Klasa szkieletu.
class C_SKELETON
{
public:
	struct DRAWORDER
	{
		XE_SPRITE*				Sprite;
		XE_VECTOR				Position;
		float					Angle;
		XE_VECTOR				Scale;
		float					Order;
	};
private:
	static int					SortByOrder(DRAWORDER* a,DRAWORDER* b);
	XE_CONTAINER<C_SKELETON>	Bones;
public:
								//! Sprajt kosci.
	XE_SPRITE					Sprite;
								//! Wzgledny obrot kosci.
	float						Angle;
								//! Dlugosc kosci.
	float						Length;
								//! Skala.
	XE_VECTOR					Scale;
								//! Dlugosc promienia kuli otaczajacej punkty kosci.
	float						Range;
								//! Rysuje odwroconego sprajta (w punkcie konca kosci).
	bool						Invert;
								//! Glebokosc w kolejnosci rysowania.
	float						Order;
								//! Ustala czy kosc i jej dzieci sa widoczne.
	bool						Visible;
								/*! Konstruktor domyslny. */
								C_SKELETON();
								/*! Zwalnia szkielet z pamieci. */
	void						Free();
								/*! Rysuje kosci.
								\param pos Wektor pozycji.
								\param relangle Wzgledny kat obrotu.
								\param zorderdir Wektor przesuniecia pozycji wzgledem kolejnosci rysowania.
								*/
	void						Draw(XE_VECTOR pos,float relangle=0,XE_VECTOR zorderdir=0);
								/*! Rysuje kosci posortowane wedlug glebokosci.
								\param pos Wektor pozycji.
								\param relangle Wzgledny kat obrotu.
								\param zorderdir Wektor przesuniecia pozycji wzgledem kolejnosci rysowania.
								\param list Wskaznik na liste elementow do posortowania i narysowania.
								*/
	void						DrawSorted(XE_VECTOR pos,float relangle=0,XE_VECTOR zorderdir=0,XE_ELEMENTS<DRAWORDER>* list=0);
								/*! Zwraca pozycje kosci.
								\param path Sciezka kosci.
								\param pos Wektor pozycji.
								\param relangle Wzgledny kat obrotu.
								\return Wektor pozycji bezwzglednej.
								*/
	XE_VECTOR					Position(char* path,XE_VECTOR pos,float relangle=0);
								/*! Zwraca wzgledny kat obrotu kosci.
								\param path Sciezka kosci.
								\param relangle Wzgledny kat obrotu.
								\return Wzgledny kat obrotu kosci.
								*/
	float						RelativeAngle(char* path,float relangle=0);
								/*! Zwraca pozycje centrum kosci.
								\param pos Wektor pozycji.
								\param relangle Wzgledny kat obrotu.
								\return Wektor pozycji srodka ukladu.
								*/
	XE_VECTOR					Center(XE_VECTOR pos,float relangle=0);
								/*! Oblicza granice prostokata kolizyjnego.
								\param bboxmin Referencja na wynikowa minimalna granice prostokata kolizyjnego.
								\param bboxmax Referencja na wynikowa maksymalna granice prostokata kolizyjnego.
								\param pos Wektor pozycji.
								\param relangle Wzgledny kat obrotu.
								*/
	void						BoundingBox(XE_VECTOR& bboxmin,XE_VECTOR& bboxmax,XE_VECTOR pos=XE_VECTOR(),float relangle=0);
								/*! Oblicza promien i pozycje okregu kolizyjnego.
								\param centerpos Referencja na wynikowa pozycje srodka okregu kolizyjnego.
								\param pos Wektor pozycji.
								\param relangle Wzgledny kat obrotu.
								\param range Promien okregu.
								\return Promien okregu kolizyjnego.
								*/
	float						BoundingCircle(XE_VECTOR& centerpos,XE_VECTOR pos=XE_VECTOR(),float relangle=0,float range=0);
								/*! Dostep do kosci podrzednej o danej sciezce.
								\param path Sciezka kosci.
								\param mode Tryb dostepu.
								\param parent Wskaznik na kosc w ktorej szukamy sciezki lub wartosc NULL jesli to ten sam obiekt ktory wywoluje ta metode.
								\return Wskaznik na kosc, badz wartosc NULL jesli kosc nie istnieje.
								*/
	C_SKELETON*					Access(char* path,XEF_ESTATE mode=XEF_CREATE,C_SKELETON* parent=0);
								/*! Operator dostepu do kosci podrzednej.
								\param path Sciezka kosci.
								\return Referencja na obiekt znalezionej lub utworzonej kosci.
								*/
	C_SKELETON&					operator[](char* path);
								/*! Ustala kolor sprajtow kosci.
								\param col Wektor koloru.
								*/
	void						SetColor(XE_HALFVECTOR col);
};

#ifdef XE_CANIMP

int C_SKELETON::SortByOrder(DRAWORDER* a,DRAWORDER* b)
{
	if(a->Order==b->Order)return(0);
	if(a->Order>b->Order)return(1);
	return(-1);
}

C_SKELETON::C_SKELETON()
{
	Angle = 0;
	Length = 0;
	Scale = XE_VECTOR(1,1);
	Range = 0;
	Invert = false;
	Order = 0;
	Visible = true;
}

void C_SKELETON::Free()
{
	Sprite=XE_SPRITE();
	XE_FOREACH(C_SKELETON,Bones,elm)
		elm->Free();
	Bones.Clear();
}

void C_SKELETON::Draw(XE_VECTOR pos,float relangle,XE_VECTOR zorderdir)
{
	if(!Visible)return;
	XE_VECTOR boneend=pos+XeLengthdirLen(Angle+relangle,Length);
	if(!Invert)
		Sprite.Draw((zorderdir==XE_VECTOR(0,0))?(pos):(pos+zorderdir*XE_NUMBER(Order)),Angle+relangle,Scale);
	else
		Sprite.Draw((zorderdir==XE_VECTOR(0,0))?(boneend):(boneend+zorderdir*XE_NUMBER(Order)),Angle+relangle+180,Scale);
	XE_FOREACH(C_SKELETON,Bones,elm)
		elm->Draw(boneend,Angle+relangle,zorderdir);
}

void C_SKELETON::DrawSorted(XE_VECTOR pos,float relangle,XE_VECTOR zorderdir,XE_ELEMENTS<DRAWORDER>* list)
{
	if(!Visible)return;
	XE_ELEMENTS<DRAWORDER>* draworder=0;
	if(!list)
		draworder=new XE_ELEMENTS<DRAWORDER>;
	else
		draworder=list;
	XE_VECTOR boneend=pos+XeLengthdirLen(Angle+relangle,Length);
	XE_ELEMENT_POINTER<DRAWORDER> dorder=draworder->AddPointer(DRAWORDER());
	if(!Invert)
	{
		dorder->Sprite=&Sprite;
		dorder->Position=(zorderdir==XE_VECTOR(0,0))?(pos):(pos+zorderdir*XE_NUMBER(Order));
		dorder->Angle=Angle+relangle;
		dorder->Scale=Scale;
		dorder->Order=Order;
	}
	else
	{
		dorder->Sprite=&Sprite;
		dorder->Position=(zorderdir==XE_VECTOR(0,0))?(boneend):(boneend+zorderdir*XE_NUMBER(Order));
		dorder->Angle=Angle+relangle+180;
		dorder->Scale=Scale;
		dorder->Order=Order;
	}
	XE_FOREACH(C_SKELETON,Bones,elm)
		elm->DrawSorted(boneend,Angle+relangle,zorderdir,draworder);
	if(!list)
	{
		draworder->Sort(SortByOrder);
		XE_FOREACH(DRAWORDER,(*draworder),elm)
			elm->Sprite->Draw(elm->Position,elm->Angle,elm->Scale);
		delete draworder;
	}
}

XE_VECTOR C_SKELETON::Position(char* path,XE_VECTOR pos,float relangle)
{
	XE_STRING word;
	XE_STRING temp=path;
	unsigned int p=temp.Search(word,"/");
	if(!word.Length())return(pos);
	XE_ELEMENT_POINTER<C_SKELETON> elm=Bones(word);
	if(!p)
		return(pos+XeLengthdirLen(Angle+relangle,Length));
	else
		return(elm->Position(&path[p],pos+XeLengthdirLen(Angle+relangle,Length),Angle+relangle));
}

float C_SKELETON::RelativeAngle(char* path,float relangle)
{
	XE_STRING word;
	XE_STRING temp=path;
	unsigned int p=temp.Search(word,"/");
	if(!word.Length())return(relangle);
	XE_ELEMENT_POINTER<C_SKELETON> elm=Bones(word);
	if(!p)
		return(Angle+relangle);
	else
		return(elm->RelativeAngle(&path[p],Angle+relangle));
}

XE_VECTOR C_SKELETON::Center(XE_VECTOR pos,float relangle)
{
	XE_VECTOR bmin;
	XE_VECTOR bmax;
	BoundingBox(bmin,bmax,pos,relangle);
	return((bmin+bmax)*XE_NUMBER(0.5));
}

void C_SKELETON::BoundingBox(XE_VECTOR& bboxmin,XE_VECTOR& bboxmax,XE_VECTOR pos,float relangle)
{
	if(bboxmax-bboxmin==XE_VECTOR())
	{
		bboxmin=pos;
		bboxmax=pos;
	}
	XE_VECTOR boneend=pos+XeLengthdirLen(Angle+relangle,Length);
	bboxmin=bboxmin.Min(pos-XE_VECTOR(Range,Range));
	bboxmax=bboxmax.Max(pos+XE_VECTOR(Range,Range));
	bboxmin=bboxmin.Min(boneend-XE_VECTOR(Range,Range));
	bboxmax=bboxmax.Max(boneend+XE_VECTOR(Range,Range));
	XE_FOREACH(C_SKELETON,Bones,elm)
		elm->BoundingBox(bboxmin,bboxmax,boneend,Angle+relangle);
}

float C_SKELETON::BoundingCircle(XE_VECTOR& centerpos,XE_VECTOR pos,float relangle,float range)
{
	if(range<=0)centerpos=Center(pos,relangle);
	XE_VECTOR boneend=pos+XeLengthdirLen(Angle+relangle,Length);
	range=max(range,(float)(pos-centerpos).Length()+Range);
	range=max(range,(float)(boneend-centerpos).Length()+Range);
	XE_FOREACH(C_SKELETON,Bones,elm)
		range=max(range,elm->BoundingCircle(centerpos,boneend,Angle+relangle,range));
	return(range);
}

C_SKELETON* C_SKELETON::Access(char* path,XEF_ESTATE mode,C_SKELETON* parent)
{
	if(!parent)parent=this;
	XE_STRING word;
	XE_STRING temp=path;
	unsigned int p=temp.Search(word,"/");
	if(!p)
	{
		if(word.Length())
			return(parent->Bones(mode,word).iPointer());
		else
			return(parent);
	}
	else
	{
		if(word.Length())
			return(Access(&path[p],mode,parent->Bones(XEF_CREATE,word).iPointer()));
		else
			return(parent);
	}
}

C_SKELETON& C_SKELETON::operator[](char* path)
{
	return(*Access(path,XEF_CREATE));
}

void C_SKELETON::SetColor( XE_HALFVECTOR col )
{
	Sprite.SetColor(col);
	XE_FOREACH(C_SKELETON,Bones,elm)
		elm->SetColor(col);
}

#endif /* XE_CANIMP */

#endif /* XE_COMPILE_CORE_MATH */
#endif /* XE_COMPILE_PHOTON */

} /* namespace: Com */
} /* namespace: XeCore */

#endif /* XE_COMPONENT_2D_H */
